clear all
clc
close all

%% Import data from spreadsheet
% Script for importing data from the following spreadsheet:
%
%    Workbook: /Users/shaundatta/Documents/Game Theory UROP/DiscoveringFeatures.xlsx
%    Worksheet: 3x3
%
% To extend the code for use with different selected data or a different
% spreadsheet, generate a function instead of a script.

% Auto-generated by MATLAB on 2016/05/06 13:26:36

%% Import the data
[~, ~, raw] = xlsread('/Users/annieliang/Dropbox/Research Projects/Predicting Games/Predictability of Games/Shaun/DiscoveringFeatures.xlsx','3x3');
raw = raw(3:end,3:21);
freq=xlsread('/Users/annieliang/Dropbox/Research Projects/Predicting Games/Predictability of Games/Coding up features/frequencies');


%% Create output variable
data = reshape([raw{:}],size(raw));

%% Allocate imported array to column variable names
Cell1 = data(:,1);
Cell2 = data(:,2);
Cell3 = data(:,3);
Cell4 = data(:,4);
Cell5 = data(:,5);
Cell6 = data(:,6);
Cell7 = data(:,7);
Cell8 = data(:,8);
Cell9 = data(:,9);
Cell10 = data(:,10);
Cell11 = data(:,11);
Cell12 = data(:,12);
Cell13 = data(:,13);
Cell14 = data(:,14);
Cell15 = data(:,15);
Cell16 = data(:,16);
Cell17 = data(:,17);
Cell18 = data(:,18);
Action = data(:,19);

%% Clear temporary variables
clearvars data raw;

gamesMatrix = [Cell1,Cell2,Cell3,Cell4,Cell5,Cell6,Cell7,Cell8,Cell9,Cell10,Cell11,Cell12,Cell13,Cell14,Cell15,Cell16,Cell17,Cell18];


%% Binary outcome for whether most played

[n,m]=size(gamesMatrix);

Act=cell(1,3);
Act{1}=zeros(1,n);
Act{2}=zeros(1,n);
Act{3}=zeros(1,n);

Act{1}(find(Action==1))=1;
Act{2}(find(Action==5))=1;
Act{3}(find(Action==9))=1;

%% Change Action labels

Action(find(Action==9))=3;
Action(find(Action==5))=2;
Action(find(Action==1))=1;
    
gamesMatrix(77,:)=[];
Action(77)=[];
Act{1}(77)=[];
Act{2}(77)=[];
Act{3}(77)=[];
    

save Data gamesMatrix Act Action freq